@echo off
setlocal enabledelayedexpansion
title CLS Team - Disable HPET

echo CLS Team - High Precision Event Timer Disabler
echo ==============================================

echo Disabling High Precision Event Timer...
echo.

REM Method 1: Disable HPET using devcon
echo Method 1: Using devcon tool...
if exist devcon.exe (
    devcon disable "*HPET*"
    devcon disable "*INT0800*"
    echo HPET disabled via devcon.
) else (
    echo devcon.exe not found, using alternative methods...
)

REM Method 2: Disable using pnputil
echo.
echo Method 2: Using pnputil...
pnputil /enum-devices /class System | findstr /i "HPET" >nul
if !errorlevel! equ 0 (
    for /f "tokens=2 delims=:" %%I in ('pnputil /enum-devices /class System ^| findstr /i "HPET"') do (
        set "instanceId=%%I"
        set "instanceId=!instanceId: =!"
        if not "!instanceId!"=="" (
            echo Disabling HPET: !instanceId!
            pnputil /disable-device "!instanceId!" >nul
        )
    )
)

REM Method 3: Direct registry approach
echo.
echo Method 3: Registry method...
set "hpetKey=HKLM\SYSTEM\CurrentControlSet\Enum\ACPI\PNP0103"
set "configKey=HKLM\SYSTEM\CurrentControlSet\Control\Class\{50127dc3-0f36-415e-a6cc-4cb3be910b65}"

reg query "!hpetKey!" >nul 2>&1
if !errorlevel! equ 0 (
    for /f "tokens=3 delims= " %%I in ('reg query "!hpetKey!" /s ^| findstr "InstanceId"') do (
        set "hpetInstance=%%I"
        echo Found HPET instance: !hpetInstance!
        reg add "!hpetKey!\!hpetInstance!\Device Parameters" /v "Enable" /t REG_DWORD /d 0 /f >nul
    )
)

REM Method 4: BIOS emulation disable
echo.
echo Method 4: BIOS configuration...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\HPET" /v "Start" /t REG_DWORD /d 4 /f >nul 2>&1

REM Disable in memory management
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "EnableHPET" /t REG_DWORD /d 0 /f >nul 2>&1

echo.
echo HPET disable operations completed!
echo.
echo Note: Some changes may require reboot to take effect.
echo Check Device Manager for HPET status.
pause